############### ###############
## 06 - CBO individuals preparation for analysis
## Project: CBO
## PI: Malte Lierl
## Written by: Kamil Kouhen
## Purpose: Making last adjustments and adding useful variables before analysis
## Date of creation: 18/04/2022
############### ###############

library(here)
#Running preceding code
#source(here("Code","Rcode", "05 - preparation - CBO individuals cleaning.R"), echo = T) #Cleaning of CBO individual ds

#Loading cleaned intermediate individual ds
CBO_individuals_intermediate <- readRDS(here(datatype, "Intermediate", "CBO_individuals_intermediate.RDS"))

#First restricting to CBOs that are included in the analysis: scorecard posted and municipal training performed
CBO_individuals_final <- CBO_individuals_intermediate %>%
  filter(Municipality_included_MON == 1) %>%

#Creating weights to compensate for the uneven number of individual per CBO
  group_by(appcode) %>% #grouping by CBO
  mutate(todrop_countCBO = n()) %>%
  mutate(IND_weight = (1/todrop_countCBO)) %>% 
  ungroup() %>%
  select(-contains("todrop_")) %>%

#NA if refuse to answer or don't know
  na_if("dk") %>% na_if("refuse") %>% na_if("rfs")

### For Hypothesis 2 - time_investment: Frequency at which individual volunteers an hour or more to do something for the CBO ### 
#Using original variable: time_investment
  
### For Hypothesis 2 - cbo_conflict: Individual says that there is often conflict among the members of the CBO ### 
#Simply using original variable: cbo_conflict
CBO_individuals_final %<>% 
  mutate(A_cbo_conflict = as.numeric(cbo_conflict)) %>%
  mutate(A_cbo_conflict = 
           case_when(
             A_cbo_conflict == 2 ~ 0,
             A_cbo_conflict == 4 ~ 1
           )) 

### For Hypothesis 2 - cbo_satisfaction: Individual is satisfied with the leadership of the CBO ### 
#Simply using original variable: cbo_satisfaction
### For Hypothesis 2 - cbo_enthusiasm: Individual's general satisfaction about being a member of the CBO ### 
#Simply using original variable: cbo_enthusiasm
### For Hypothesis 2 - cbo_capture: Individual believes the CBO does not serve the common interests of members ### 
#Simply using original variable: cbo_capture

#Saving final dataset before analysis
saveRDS(CBO_individuals_final, file = here(datatype, "Final", "CBO_individuals_final.RDS"))

message("**06 completed")





